﻿

var data;
var sentiments;
var reloadDashboard = false;
var isShow = false;
var isResponseEdited = false;
var sentimentCategory = "";
$(document).on("change", "#positiveColor", function () {
    colorChanged('#positiveColor');
});
$(document).on("change", "#negativeColor", function () {
    colorChanged('#negativeColor');
});
$(document).on("change", "#neutralColor", function () {
    colorChanged('#neutralColor');
});

$(document).on("change", "#color1", function () {
    wordCloudColorChanged('#color1');
    generateWordCloudwithData();
});
$(document).on("change", "#color2", function () {
    wordCloudColorChanged('#color2');
    generateWordCloudwithData();
});
$(document).on("change", "#color3", function () {
    wordCloudColorChanged('#color3');
    generateWordCloudwithData();
});


$(document).on("change", "#selectedTheme", function () {
    if ($("#selectedTheme").val() === 'Custom') {
        $("#customColorTheme").show();
    } else {
        $("#customColorTheme").hide();
    }
    generateWordCloudwithData();
});

$(document).on("change", "#horizontalCheck", function () {
    generateWordCloudwithData();
});
$(document).on("change", "#veriticalCheck", function () {
    generateWordCloudwithData();
});
$(document).on("change", "#wordCountLimit", function () {
    generateWordCloudwithData();
});
$(document).on("change", "#stopwords", function () {
    generateWordCloudwithData();
});

$(document).on("change", "#selectedFont", function () {
    generateWordCloudwithData();
});
$("#resetSentimentColors").on("click", function (event) {
    resetSentimentPerformanceColors();
    showResetButton();
    event.preventDefault();
})

function resetSentimentPerformanceColors() {
    $("#positiveColor").val("#43B17B");
    $("#neutralColor").val("#33B6F0");
    $("#negativeColor").val("#E94444");
    $("#positiveColorText").val("#43B17B");
    $("#neutralColorText").val("#33B6F0");
    $("#negativeColorText").val("#E94444");
    if (data) {

        for (var index = 0; index < data.length; index++) {
            switch (data[index]['Category']) {
                case resources.Positive:
                    data[index]['Color'] = '#43B17B';
                    break;
                case resources.Neutral:
                    data[index]['Color'] = "#33B6F0";
                    break;
                default:
                    data[index]['Color'] = "#E94444";
                    break;
            }
        }
        updateChartColor(data);
    }
}

function generateWordCloudwithData() {
    var config = {
        Theme: $("#selectedTheme").val(),
        ThemeColors: $('#color1').val() + "," + $("#color2").val() + "," + $("#color3").val(),
        Font: $("#selectedFont").val(),
        Direction: $("#horizontalCheck").is(':checked') + "," + $("#veriticalCheck").is(':checked'),
        WordLimit: $("#wordCountLimit").val(),
        StopWords: stopwordList.toString()
    }
    var language;
    generateCloud(dashboardResults.wordCloudText, config, language, true,"wordCloudEdit");
}

$(document).ready(function () {
    var viewName = $('#typeId').val();
    var variableId = $('#variableId').val();
    var topicName = $('#topicName').val();  

    filterAnalytics.SentimentType = $('#sentimentType').val() == 'All' ? "" : $('#sentimentType').val();
    filterAnalytics.FromDate = $('#fromDate').val();
    filterAnalytics.ToDate = $('#toDate').val();
    filterAnalytics.FilterAction = $('#filterAction').val();
    filterAnalytics.ResponseFilterJSON = $('#responseFilterJSON').val();

    if (viewName) {
        var params = {
            variableId: variableId,
            surveyId: a4.getSurveyId(),
            topicName: topicName,
            filterAnalytics: filterAnalytics
        };

        var hasEdit = $('#hasEdit').val() === "true";
        if (viewName == "SentimentPerformance") {
            if (hasEdit) {
                $('#saveSentiment').show();
                $('#editSentiment').hide();
                $('#overallSentimentHeader').text(resources.EditSentimentPerformance);
                $('#SentimentResponses').hide();
                showResetButton();
            } else {
                $('#saveSentiment').hide();
            }
            a4.callServerMethod(a4.getSurveyAction("GetSentimentPerformanceData", "AdvancedAnalytics"), params, function (response) {
                data = response['SentimentList'];
                $("#positiveColorText").val(response['DashboardColorScheme']['PositiveColor']);
                $("#negativeColorText").val(response['DashboardColorScheme']['NegativeColor']);
                $("#neutralColorText").val(response['DashboardColorScheme']['NeutralColor']);

                $("#positiveColor").val(response['DashboardColorScheme']['PositiveColor']);
                $("#negativeColor").val(response['DashboardColorScheme']['NegativeColor']);
                $("#neutralColor").val(response['DashboardColorScheme']['NeutralColor']);
                if (hasEdit) {
                    editSentimentPerformance();
                    showResetButton();
                } else {
                    renderPieChart(response['SentimentList'], true, 80, 55, true, "right", 16, 18);
                }
                const total = response['SentimentList'].reduce((accumulator, object) => {
                    return accumulator + object.Value;
                }, 0);
                $('#totalId').text(total);
            });
        }
        else if (viewName == "WordCloud") {
            if (hasEdit) {
                $("#cloudtitle").text(resources.Edit + " " + resources.WordCloud);
                $("#editbutton").hide();
                $("#savebutton").show();
                $("#closeButton").text(resources.Cancel);
            } else {
                $("#savebutton").hide();
            }

            var surveyLanguage = $('#surveyLanguage').val();                
            a4.callServerMethod(a4.getSurveyAction("GetWordCloudData", "AdvancedAnalytics"), params, function (response) {
                if (response['Config']) {
                    updateConfigData(response['Config']);
                } else {
                    $("#color1").val('#15465B');
                    $("#color2").val('#0B5677');
                    $("#color3").val('#0076A9');
                    $("#color1Text").val('#15465B');
                    $("#color2Text").val('#0B5677');
                    $("#color2Text").val('#0076A9');
                }
                if (hasEdit) {
                    editWordCloud(true);
                }
                generateCloud(response['Text'], response['Config'], surveyLanguage, hasEdit, "wordCloudEdit");
                
            });
        }
        else if (viewName == "Topics") {
            if (hasEdit) {
                $("#delete-topic").hide();
            }
            a4.callServerMethod(a4.getSurveyAction("GetTopicDataData", "AdvancedAnalytics"), params, function (response) {
                generateTopicTable(response['Topics'], true, response['DashboardColorScheme']['PositiveColor'], response['DashboardColorScheme']['NegativeColor'], response['DashboardColorScheme']['NeutralColor'], hasEdit);
                var topicSearch = $('#topicSearchInput').val();
                if (topicSearch != "") {
                    searchTopics();
                }
            });
        } else {
            var variableId = $('#variableId').val();
            var topicName = $('#topicName').val();
            var positiveCount = $('#positiveCount').val();
            var negativeCount = $('#negativeCount').val();
            var neutralCount = $('#neutralCount').val();
            var colorScheme = JSON.parse($('#colorScheme').val());
            sentimentCategory = $('#sentimentCategory').val();
            var modifyDashboardPermissionAllowed = $('#modifyDashboard').val() == "True" ? true : false;
            openEndAnswerFullscreen(variableId, topicName, positiveCount, negativeCount, neutralCount, hasEdit, false, sentimentCategory, colorScheme, modifyDashboardPermissionAllowed);
            getDashboardColorScheme(variableId);
            setTimeout(() => {
                addClass('div.dataTables_filter', 'fullscreen_openandanswers_search');
                addClass('div.bottom.clearfix', 'fullscreen-openandanswers-paging');
                addClass('div.top.clearfix', 'm-t-minus40');
                addClass('div.dataTables_scrollBody', 'fullscreen-scrollbody');
                addClass('.multi-edit-toggle', 'dis-n');
                if (hasEdit)
                {
                    editOpenAndAnswers();
                }
            }, 500);           
        }
    }
});

function showResetButton() {
    if ($("#neutralColor").val().toUpperCase() === '#33B6F0' && $("#negativeColor").val().toUpperCase() === '#E94444' && $("#positiveColor").val().toUpperCase() === '#43B17B') {
        $("#resetSentimentColors").hide();
    } else {
        $("#resetSentimentColors").show();
    }
}

function editWordCloud(hasText = false) {
    $("#cloudtitle").text(resources.Edit + " " + resources.WordCloud);
    $("#closeButton").text(resources.Cancel);
    $("#wordcloudConfig").show();
    $("#editbutton").hide();
    $("#savebutton").show();
    if (!isShow) {
        $("#customColorTheme").hide();
    }
    if (!hasText) {
        generateWordCloudwithData();
    }
}
var stopwordList = [];
function updateConfigData(config) {
    if (config['Theme']) {
        $("#selectedTheme").val(config['Theme']);
    } else {
        $("#selectedTheme").val('Custom');
        $("#customColorTheme").show();
        isShow = true;
    }
    if (config['Theme'] === 'Custom') {
        var colors = config['ThemeColors'].split(",");
        $("#color1").val(colors[0]);
        $("#color2").val(colors[1]);
        $("#color3").val(colors[2]);
        $("#color1Text").val(colors[0]);
        $("#color2Text").val(colors[1]);
        $("#color3Text").val(colors[2]);
        $("#customColorTheme").show();
        isShow = true;
    } else {
        $("#color1").val('#15465B');
        $("#color2").val('#0B5677');
        $("#color3").val('#0076A9');
        $("#color1Text").val('#15465B');
        $("#color2Text").val('#0B5677');
        $("#color2Text").val('#0076A9');
    }
    if (config['Direction']) {
        var checked = config['Direction'].split(",");
        if (checked[0] === 'true') {
            $("#horizontalCheck").prop('checked', true);
        }
        if (checked[1] === 'true') {
            $("#veriticalCheck").prop('checked', true);
        }
    } else {
        $("#horizontalCheck").prop('checked', true);
        $("#veriticalCheck").prop('checked', true);
    }
    if (config['StopWords']) {
        $("#stopwords").val(config['StopWords']);
        stopwordList = config['StopWords'].split(",");
        renderStopWords();
    }
    if (config['Font']) {
        $("#selectedFont").val(config['Font']);
    }
    if (config['WordLimit'] && config['WordLimit'] !== 0) {
        $("#wordCountLimit").val(config['WordLimit']);
    } else {
        $("#wordCountLimit").val(100);
    }

}

$('#stopword').on('keypress', function (ev) {
    if (ev.which == 32) {
        return false;
    }
    var value = $("#stopword").val();
    if ((ev.key == 'Enter' || ev.keyCode === 13) && value.trim() !== '') {
        renderStopWord(value);
        $("#stopword").val('');
    }
});

function renderStopWords() {
    var wordssection = $("#wordsSection");
    for (var index = 0; index < stopwordList.length; index++) {
        var section = $("<div id='word" + index + "'>").addClass("element-section");
        $(section).append($("<div id='" + index + "'>")).addClass("stop-word").append(stopwordList[index])
            .append($("<span class='remove-word' onclick='removeElement("+index+");return false'>").append($("<i class='fa fa-times-circle-o'>"))
           );
        $(wordssection).append(section);
    }
}

function removeElement(index) {
    $("#wordsSection").empty();
    stopwordList.splice(index, 1);
    renderStopWords();
    generateWordCloudwithData();
}

function renderStopWord(stopWord) {
    $("#wordsSection").empty();
    stopwordList.push(stopWord);
    renderStopWords();
    generateWordCloudwithData();
}

function saveOrUpdateWordCloudConfig() {
    var vericalChecked = $("#veriticalCheck").is(':checked');
    var horizontalChecked = $("#horizontalCheck").is(':checked');

    if (!vericalChecked && !horizontalChecked) {
        a4.showErrorMessage(resources.DirectionErrorMessage);
        return;
    }

    if ($("#wordCountLimit").val() <= 0) {
        a4.showErrorMessage(resources.WordCountLimitErrorMessage);
        return;
    }

    var postData = {
        Theme: $("#selectedTheme").val(),
        ThemeColors: $('#color1').val() + "," + $("#color2").val() + "," + $("#color3").val(),
        Font: $("#selectedFont").val(),
        Direction: horizontalChecked + "," + vericalChecked,
        WordLimit: $("#wordCountLimit").val(),
        StopWords: stopwordList.toString(),
        VariableId: $('#variableId').val()
    }
    a4.callServerMethod(a4.getSurveyAction("SaveOrUpdateWordCloudConfig", "AdvancedAnalytics"), postData, function (response) {
        postData['View'] = 'wordcloud';
        modalDialog.close(postData);
    });
}
function wordCloudColorChanged(id) {
    $(id + "Text").val($(id).val());
}
function colorChanged(id) {
    $(id + "Text").val($(id).val());
    if (data) {

        for (var index = 0; index < data.length; index++) {
            switch (data[index]['Category']) {
                case resources.Positive:
                    data[index]['Color'] = $("#positiveColor").val();
                    break;
                case resources.Neutral:
                    data[index]['Color'] = $("#neutralColor").val();
                    break;
                default:
                    data[index]['Color'] = $("#negativeColor").val();
                    break;
            }
        }
        showResetButton();
        updateChartColor(data);
    }
}

function addClass(selector, className) {
    $(selector).addClass(className);
}
function removeClass(selector, className) {
    $(selector).removeClass(className);
}

function editOpenAndAnswers() {
    $("#openEndAnswersHeader").text(resources.EditOpenEndAnswersTitle);
    removeClass('.sentiment-text-column', 'dis-b');
    removeClass('.sentiment-enum-column', 'dis-n');
    removeClass('.multi-edit-toggle', 'dis-n');
    addClass('#editOpenANdAnswers', 'dis-n');
    addClass('.sentiment-text-column', 'dis-n');
    addClass('.sentiment-enum-column', 'dis-b');
}

function updateOpenAndAnswers() {
    var updatedData = dashboardResults.openEndAnswersTable.a4datatable("getUpdatedItems");
    var filtered = updatedData.filter(x => x['SentimentAnalytics'] === "");
    if (filtered.length > 0) {
        a4.showErrorMessage(resources.EmptySentiment);
        return;
    }
    var updateURL = a4.getSurveyAction("UpdateOpenAndAnswers", "AdvancedAnalytics");
    var variableId = parseInt($('#variableId').val());
    var questionName = $('#questionName').val();
    var questionId = $('#questionId').val();
    var filterAnalytics = {
        SentimentType: $('#sentimentType').val() == 'All' ? "" : $('#sentimentType').val(),
        FromDate: $('#fromDate').val(),
        ToDate: $('#toDate').val(),
        FilterAction: $('#filterAction').val()
    };
    var parameters = { responseData: updatedData, variableId: variableId, questionName: questionName, questionId: questionId, filterAnalytics: filterAnalytics, topicName: $('#topicName').val(), isResponseEdited: isResponseEdited };
    a4.callServerMethod(updateURL, parameters, function (result) {
        if (result['success']) {
                sentiments = result['data'];
                var positiveCount = $('#positiveCount').val();
                var negativeCount = $('#negativeCount').val();
                var neutralCount = $('#neutralCount').val();
                openEndAnswerFullscreen(variableId, $('#topicName').val(), positiveCount, negativeCount, neutralCount, hasEdit, true, sentimentCategory);
                selectedVariableId = variableId;
        }
        if (isResponseEdited) {
            modalDialog.close({ isResponseEdited: isResponseEdited, reloadDashboard: reloadDashboard });
        }
    });
}

$(document).on("change", ".response-text-edit", function () {
    isResponseEdited = true;
});

$(document).on("change", ".sentiment-enum-column", function () {
    reloadDashboard = true;
});

function closeOpenEndAnswers() {
    modalDialog.close({ reloadDashboard: reloadDashboard });
}
function editSentimentPerformance() {
    $('#SentimentColorPicker').show();
    $('#hr_line').show();
    showResetButton();
    $('#SentimentResponses').hide();
    $('#saveSentiment').show();
    $('#editSentiment').hide();
    $('#overallSentimentHeader').text(resources.EditSentimentPerformance);
    $('#closeButton').text(resources.Cancel);
    renderPieChart(data, false, 80, 55, false);
}
function updateSentimentPerformance() {
    var positiveColor = $('#positiveColor').val();
    var neutralColor = $('#neutralColor').val();
    var negativeColor = $('#negativeColor').val();

    if (positiveColor === neutralColor | positiveColor === negativeColor | neutralColor === negativeColor) {
        a4.showErrorMessage(resources.DashboardSameSentimentColorError);
    } else {
        var colorScheme = { PositiveColor: positiveColor, NeutralColor: neutralColor, NegativeColor: negativeColor }
        for (var index = 0; index < data.length; index++) {
            switch (data[index]['Category']) {
                case resources.Positive:
                    data[index]['Color'] = positiveColor
                    break;
                case resources.Neutral:
                    data[index]['Color'] = neutralColor
                    break;
                default:
                    data[index]['Color'] = negativeColor
                    break;

            }
        }
        updateChartColor(data);
        var editConfig = { data: data, colorScheme: colorScheme };
        modalDialog.close(editConfig);
        var parameters = {
            DashboardColorScheme: colorScheme,
            SurveyId: a4.getSurveyId,
            VariableId: $('#variableId').val()
        };
        var editUrl = a4.getSurveyAction("EditSentimentPerformance", "AdvancedAnalytics");
        a4.callServerMethod(editUrl, parameters, function (result) {
            if (result['success']) {
                modalDialog.close(editConfig);
            }
        });
    }
}